CREATE TABLE S (
    SNO CHAR(2) PRIMARY KEY,
    SNAME VARCHAR(20) NOT NULL,
    STATUS INT,
    CITY VARCHAR(20)
);
GO

CREATE TABLE P (
    PNO CHAR(2) PRIMARY KEY,
    PNAME VARCHAR(20) NOT NULL,
    COLOR VARCHAR(10),
    WEIGHT INT
);
GO

CREATE TABLE J (
    JNO CHAR(2) PRIMARY KEY,
    JNAME VARCHAR(20) NOT NULL,
    CITY VARCHAR(20)
);
GO

CREATE TABLE SPJ (
    SNO CHAR(2),
    PNO CHAR(2),
    JNO CHAR(2),
    QTY INT,
    PRIMARY KEY (SNO, PNO, JNO),
    FOREIGN KEY (SNO) REFERENCES S(SNO),
    FOREIGN KEY (PNO) REFERENCES P(PNO),
    FOREIGN KEY (JNO) REFERENCES J(JNO)
);
GO

INSERT INTO S (SNO, SNAME, STATUS, CITY)
VALUES 
('S1', '精益', 20, '天津'),
('S2', '盛锡', 10, '北京'),
('S3', '东方红', 30, '北京'),
('S4', '丰泰盛', 20, '天津'),
('S5', '为民', 30, '上海');
GO

INSERT INTO P (PNO, PNAME, COLOR, WEIGHT)
VALUES 
('P1', '螺母', '红', 12),
('P2', '螺栓', '绿', 17),
('P3', '螺丝刀', '蓝', 14),
('P4', '螺丝刀', '红', 14),
('P5', '凸轮', '蓝', 40),
('P6', '齿轮', '红', 30);
GO

INSERT INTO J (JNO, JNAME, CITY)
VALUES 
('J1', '三建', '北京'),
('J2', '一汽', '长春'),
('J3', '弹簧厂', '天津'),
('J4', '造船厂', '天津'),
('J5', '机车厂', '唐山'),
('J6', '无线电厂', '常州'),
('J7', '半导体厂', '南京');
GO

INSERT INTO SPJ (SNO, PNO, JNO, QTY)
VALUES 
('S1', 'P1', 'J1', 200),
('S1', 'P1', 'J3', 100),
('S1', 'P1', 'J4', 700),
('S1', 'P2', 'J2', 100),
('S2', 'P3', 'J1', 400),
('S2', 'P3', 'J2', 200),
('S2', 'P3', 'J4', 500),
('S2', 'P3', 'J5', 400),
('S2', 'P5', 'J1', 400),
('S2', 'P5', 'J2', 100),
('S3', 'P1', 'J1', 200),
('S3', 'P3', 'J1', 200),
('S4', 'P5', 'J1', 100),
('S4', 'P6', 'J3', 300),
('S4', 'P6', 'J4', 200),
('S5', 'P2', 'J4', 100),
('S5', 'P3', 'J1', 200),
('S5', 'P6', 'J2', 200),
('S5', 'P6', 'J4', 500);
GO
